 ; Ŀ
 ;   Piranha - read a text file into variables and sysvars.                
 ;   Copyright 2001, 2002 by Rocket Software Ltd.                          
 ;   This is intended to be called in silent mode (C:Pike - just update    
 ;   the file, no dialog box) when a drawing is opened, and the full-on    
 ;   dialog box version (C:Piranha) when called by the user.               
 ;                                                                         
 ;   If there's no madness then there's probably no method.                
 ; 

 ; Ŀ
 ;   Hidden utility: Placo: read a datafile into a list of strings,        
 ;   remove any which don't still exist, rewrite the file.                 
 ;   Note that comments are preserved, although those on their own line    
 ;   may belong to a deleted file name.                                    
 ; 
 (DEFUN C:PLACO (/ filnam namlst num subnam gnulis)
  (if (and (setq filnam (getfiled "Data File" "Lastfile" "" 6))
           (setq namlst (bite filnam))
           (> (length namlst) 1))
      (progn
           (setq num 0)
           (while (setq subnam (nth num namlst))
                  (while (= (substr subnam 1 1) " ")
                         (setq subnam (substr subnam 2)))
                  (if (or (= ";" (substr subnam 1 1))
                          (findfile (car (splat ";" subnam))))
                      (setq gnulis (cons subnam gnulis)))
                  (grtext -1 (itoa (setq num (1+ num)))))
           (setq gnulis (reverse gnulis))
 ; Ŀ
 ;   Put the list back into the file.                                      
 ; 
           (setq fn (open filnam "w"))
           (setq num 0)
           (while (setq subnam (nth num gnulis))
                  (grtext -1 (itoa (setq num (1+ num))))
                  (write-line subnam fn))
           (close fn))
      (prompt "No Lastfile data available."))
 (princ))
 ; Ŀ
 ;   C:Placo end.                                                          
 ; 

 ; Ŀ
 ;   Spath - split a path and filename string into a path and a filename.  
 ; 
 (DEFUN SPATH (tt / pos pp)
 ; Ŀ
 ;   Set the pointer Pos to the end of the string.                         
 ; 
  (setq pos (strlen tt))                            ; start at end of string
 ; Ŀ
 ;   Remove path.                                                          
 ; 
  (while (< 0 pos)
          (if (or (= (substr tt pos 1) (chr 92))    ; if char = \
                  (= (substr tt pos 1) ":"))        ; if char = :
             (progn
                   (setq pp (substr tt 1 pos))      ; then set pp to all before
                   (setq tt (substr tt (1+ pos)))   ;          tt to all after
                   (setq pos 1)))                   ;      and pos to first
         (setq pos (1- pos)))                       ; set pos to previous
 (list pp tt))
 ; Ŀ
 ;   Spath end.                                                            
 ; 

 ; Ŀ
 ;   Bite: read a datafile into a list of strings.                         
 ;   Takes one argument, the file name.                                    
 ;   Returns a list containing either the contents of the file or - if     
 ;   it wasn't found - the name of the current drawing.                    
 ; 
 (DEFUN BITE (fnam / fn filstr namlst cnam namm namls2)
 ; Ŀ
 ;   If the datafile can be opened then read the lines into a list.        
 ;   Ignore empty lines.                                                   
 ; 
  (if (setq fn (open fnam "r"))
      (progn
           (while (setq filstr (read-line fn))
                  (while (= (substr filstr 1 1) " ")
                         (setq filstr (substr filstr 2)))
                  (if (/= filstr "")
                      (setq namlst (append namlst (list filstr)))))
           (close fn)))
 ; Ŀ
 ;   Get the current drawing name with its path.                           
 ; 
  (setq cnam (strcat (getvar "dwgprefix") (setq namm (getvar "dwgname"))))
 ; Ŀ
 ;   Reorder Namlst: If the current drawing name is a member thereof,      
 ;   move it to the front; otherwise add cnam as the new first one unless  
 ;   cnam is unnamed in which case leave it alone.                         
 ; 
  (cond ((and (/= namm "UNNAMED")
              (/= namm "Drawing1.dwg")
              (/= namm "Drawing.dwg")
               namlst
              (setq namls2 (funl namlst cnam)))
         (setq namlst namls2))
        ((and (/= namm "UNNAMED")
              (/= namm "Drawing1.dwg")
              (/= namm "Drawing.dwg"))
         (setq namlst (cons cnam namlst))))
 namlst)
 ; Ŀ
 ;   Bite end.                                                             
 ; 

 ; Ŀ
 ;   Fput: dump a list of strings into a file.                             
 ;   Arguments: Namlst, the list.                                          
 ;              Filnam, a filename with path.                              
 ;   Calls nothing, returns nothing, has a clear conscience, sleeps well.  
 ; 
 (DEFUN FPUT (namlst filnam / fn num nxfil userok user)
 ; Ŀ
 ;   If the list is longer than 1000 elements, delete the excess ones.     
 ; 
  (while (> (length namlst) 1000)
            (setq namlst (reverse (cdr (reverse namlst)))))
 ; Ŀ
 ;   Now open the data file again and replace the contents with the names  
 ;   from the list Namlst.                                                 
 ;   Note that if the current drawing is unnamed then the file isn't       
 ;   updated, though the list returned by Bite will contain its name.      
 ; 
  (if (and (/= 4 (logand 4 (getvar "cmdactive"))) ; inactivate during a script
           (/= namm "UNNAMED")
           (/= namm "Drawing1.dwg")
           (/= namm "Drawing.dwg")
           (setq fn (open filnam "w")))
      (progn
           (setq num 0)
           (while (setq nxfil (nth num namlst))
                  (setq num (1+ num))
                  (write-line nxfil fn)
 ; Ŀ
 ;   If there is a User comment line in the file, set the Userok flag.     
 ; 
                  (if (= (substr nxfil 1 1) ";")
                      (progn
                           (while (or (= (substr nxfil 1 1) ";")
                                      (= (substr nxfil 1 1) " "))
                                  (setq nxfil (substr nxfil 2)))
                           (if (= (strcase (substr nxfil 1 4) t) "user")
                               (setq userok T)))))
 ; Ŀ
 ;   Add the user line if it is required and the name is available.        
 ; 
           (cond ((and (null userok) (setq user (getvar "loginname")))
                  (write-line (strcat "\n; User: " user) fn))
                 ((null userok)
                  (write-line "\n; User: unknown" fn)))
           (close fn))))
 ; Ŀ
 ;   Fput end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Lisok - if the list box generated a callback, see if it    
 ;   was a double click or an Enter, in which case return the value of     
 ;   the tile and close the dialog box.                                    
 ; 
 (DEFUN LISOK (reason / lisval)
  (setq lisval (get_tile "the_list"))
  (if (= reason 4)
      (done_dialog)
      (set_tile "babtext" ""))
 lisval)
 ; Ŀ
 ;   Lisok end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Selok - if OK was pressed, see if a file name was          
 ;   selected, if so exit the dialog box and return the zero based index   
 ;   of that name.  Otherwise show an error.                               
 ; 
 (DEFUN SELOK (reason / lisval num str len)
  (setq lisval (get_tile "the_list"))
  (if (and lisval (/= lisval ""))
      (done_dialog)
      (progn
           (setq str2 "You must select a file name, Ninny")
           (setq str "                                              ")
           (setq str (strcat str str))
           (while (/= (setq str (substr str 2)) "")
                  (repeat 99 (sqrt 99999.0))
                  (set_tile "babtext" (strcat str str2)))))
 lisval)
 ; Ŀ
 ;   Selok end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Fibox - display a list of strings in a dialog box.         
 ;   Accepts one argument - the list.                                      
 ;   Returns a text string.                                                
 ; 
 (DEFUN FIBOX (fildat / fpath dcl_id num numf filnam fnam malist findx ret)
  (setq fpath (findfile "Lastfile"))
  (setq dcl_id (load_dialog "Piranha.dcl"))
  (new_dialog "Piranha" dcl_id)     ; must come before data for list box
 ; Ŀ
 ;   Make the filename list for the list box.                              
 ; 
  (start_list "the_list")        ; read fildata into list box
  (setq num 0)
  (setq numf 0)                  ; filenames in file
  (while (setq filnam (nth num fildat))
         (if (and (/= (substr filnam 1 1) ";")
                  (/= (substr filnam 1 4) "User"))
             (progn
                  (setq numf (1+ numf))
                  (add_list (setq fnam (car (splat ";" filnam))))
                  (setq malist (cons fnam malist))))
         (setq num (1+ num)))
  (end_list)
  (setq malist (reverse malist))
  (set_tile "babtext" (strcat (itoa numf) " name"
                              (if (= numf 1) "" "s")
                              " in file: " fpath))
 ; Ŀ
 ;   Actions for given buttons/selections.  Must come after New_dialog     
 ;   call and before Start_dialog.                                         
 ; 
  (action_tile "select_ok" "(setq findx (selok $reason))")
  (action_tile "the_list" "(setq findx (lisok $reason))")
  (action_tile "fcancel" "(setq findx ())")
 ; Ŀ
 ;   Run it.                                                               
 ; 
  (setq ret (start_dialog))
  (unload_dialog dcl_id)
 ; Ŀ
 ;   Return a file name or nil.                                            
 ; 
 (if (and findx (/= findx ""))
     (nth (read findx) malist) nil))
 ; Ŀ
 ;   Fibox end.                                                            
 ; 

 ; Ŀ
 ;   Funl - Takes two arguments, a list of strings and a test string.      
 ;   If the string is a member of the list (ignoring any trailing          
 ;   comments separated from the main string by a semicolon) then the      
 ;   list is returned with the string matching the test string moved to    
 ;   the front.  Otherwise nil is returned.                                
 ; 
 (DEFUN FUNL (liss str / gnulis found sub)
  (setq str (strcase str))
  (while (setq sub (car liss))
         (setq liss (cdr liss))
         (if (= str (strcase (car (splat ";" sub))))
             (progn
                  (setq found T)
                  (setq gnulis (cons sub (reverse gnulis)))
                  (setq gnulis (append gnulis liss))
                  (setq liss ()))
             (setq gnulis (cons sub gnulis))))
 (if found gnulis))
 ; Ŀ
 ;   Funl end.                                                             
 ; 

 ; Ŀ
 ;   Opin - open a drawing.                                                
 ;   Takes one argument, a filename.                                       
 ;   Returns nothing.                                                      
 ; 
 (DEFUN OPIN (filnam / eoq namm gnunam)
  (setq namm (getvar "dwgname"))
 ; Ŀ
 ;   If the drawing was modified then Acad will ask if want to save the    
 ;   Changes.  If so then qsave, or if the drawing is unnamed get a        
 ;   filename and do a saveas.                                             
 ; 
  (if (/= (getvar "dbmod") 0)
      (progn
           (initget "Yes No")
           (setq eoq (getkword "Save changes? <Y>: "))               
           (if (null eoq) (setq eoq "Yes"))
           (cond ((and (= eoq "Yes")
                       (or (= namm "UNNAMED")
                           (= namm "Drawing1.dwg")
                           (= namm "Drawing.dwg")))
                  (setq gnunam (getfiled "New Drawing" "" "dwg" 1))
                  (command ".saveas" "" gnunam))
                 ((= eoq "Yes")
                  (command ".qsave")))))
 ; Ŀ
 ;   Now open the desired drawing.  If Eoq is "No" then the user was       
 ;   prompted to save and said no, so answer Yes (discard changes), and    
 ;   give the name of the file to open.                                    
 ; 
  (if (= eoq "No")
      (progn
           (command ".open")
           (command "yes")
           (command filnam))
 ; Ŀ
 ;   Otherwise dbmod was 0 or Eoq is Yes, in which case dbmod is still 0,  
 ;   so ther will be no prompt, so open the drawing.                       
 ; 
      (progn
           (command ".open")
           (command filnam)))
 (princ))
 ; Ŀ
 ;   Opin end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Splat - divide a text string into a list of substrings.    
 ;   Arguments: Sepchr, the field separator character.                     
 ;              Linn, the text string.                                     
 ;   Returns a list of field values, removes leading and trailing spaces.  
 ;                                                                         
 ;   This could probably replace Split wherever it is called...            
 ; 
 (DEFUN SPLAT (sepchr linn / len pos name1 strlst)
  (while (/= (strlen linn) 0)
         (while (and (= (substr linn 1 1) " ")
                     (/= (strlen linn) 0))
                (setq linn (substr linn 2)))
         (while (= (substr linn (setq len (strlen linn))) " ")
                (setq linn (substr linn 1 (1- len))))
         (setq pos 1)
         (setq len (strlen linn))
         (while (and (/= (substr linn pos 1) sepchr)
                     (>= len pos))
                (setq pos (1+ pos)))
         (setq name1 (substr linn 1 (1- pos)))
         (while (= (substr name1 (setq len (strlen linn))) " ")
                (setq name1 (substr name1 1 (1- len))))
         (setq linn (substr linn (1+ pos)))
         (setq strlst (append strlst (list name1))))
  (if (null strlst) (setq strlst (list "")))
  strlst)
 ; Ŀ
 ;   Splat end.                                                            
 ; 

 ; Ŀ
 ;   Piranha.  This is the dialog box part  - the file should already      
 ;   have been updated, so it just reads it into a list and displays it.   
 ; 
 (DEFUN C:PIRANHA (/ namlst filnam vbacmd)
  (setvar "cmdecho" 1)
  (if (and (setq filnam (findfile "Lastfile"))
           (setq namlst (bite filnam)))
      (if (and (setq filnam (fibox namlst))
               (/= filnam ""))
          (if (= (getvar "sdi") 0)
              (progn
                   (setq vbacmd (strcat "AcadApplication.Documents.Open \""
                                         filnam "\""))
                   (command "vbastmt" vbacmd))
              (opin filnam)))
      (prompt "No Lastfile data available."))
 (princ))

 ; Ŀ
 ;   Pike.  This is the silent data file updater.                          
 ; 
 (DEFUN C:PIKE (/ namlst filnam)
  (if (not (setq filnam (findfile "Lastfile")))
      (setq filnam (strcat (car (spath (findfile "acad.exe"))) "Lastfile")))
  (if (setq namlst (bite filnam))
      (fput namlst filnam))
 (princ))

(princ)